<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class RefundOrderStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'customer_id' => 'required',
            'items' => 'required',
            'cart_total_cost' => 'required',
            'cart_total_items' => 'required',
            'cart_total_price' => 'required',
            'cart_total_profit' => 'required',
            'payable_after_all' => 'required',
            'profit_after_all' => 'required',
            'tax' => 'required',
            'tax_amount' => 'required',
            'note' => 'sometimes',
            'display_note' => 'nullable',
            'back_to_stock' => 'required',
        ];
    }
}
