<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ProductUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules = [
            'name' => 'required|unique:products,name,' . $this->product->id,
            'category_id' => 'nullable',
            'supplier_id' => 'nullable',
            'warehouse_id' => 'nullable',
            'description' => 'nullable',
            'low_qty_alert' => 'required|numeric',
            'status' => 'sometimes|boolean',
            'barcode_symbology' => 'sometimes',
            'tax_type' => 'sometimes',
            'sku' => 'sometimes',
            'upc' => 'sometimes',
            'cost' => 'required',
            'price' => 'required',
            'is_serial_based' => 'required',
            'has_variants' => 'required|boolean',
            'serial_number' => 'sometimes',
            'identity' => 'sometimes',
            'image' => 'sometimes',

        ];

        if (request('has_variants')) {
            $rules['variants'] = 'required';
        }
        return $rules;
    }
}
