<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ProductAttributeUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules = [
            'product_id' => 'required',
            'title' => 'required',
            'sku' => 'sometimes',
            'upc' => 'sometimes',
            'cost' => 'required',
            'price' => 'required',
            'ws_price' => 'nullable',
            'supplier_id' => 'nullable',
        ];
        if (request('is_serial_based')) {
            $rules['serial_number'] = 'required';
            $rules['identity'] = 'required';
        }
        return $rules;
    }
}
