<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ImageUploadRequest extends FormRequest
{
    public function rules()
    {
        return [
            'path' => 'required',
            'image' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048', // Customize the mime types and max size as needed
        ];
    }

    public function messages()
    {
        return [
            'image.required' => __('Please select an image.'),
            'image.image' => __('The selected file must be an image.'),
            'image.mimes' => __('Only JPEG, PNG, JPG, and GIF images are allowed.'),
            'image.max' => __('The image size must not exceed 2 MB.'),
        ];
    }
}
