<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CustomProductRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'customer_id' => 'required',
            'model' => 'required',
            'cost' => 'required',
            'price' => 'required',
            'sign' => 'sometimes',
            'imei' => 'sometimes',
            'serial_number' => 'sometimes',
            'is_sold' => 'sometimes',
            'grade' => 'nullable',
            'more' => 'nullable|max:255',
            'docs' => 'sometimes',
            'image' => 'sometimes',
            'condition' => 'nullable|max:255',
        ];
    }
}
