<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CustomBillRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'customer_id' => 'required',
            'charges' => 'required',
            'description' => 'sometimes',
            'items' => 'nullable',
            'date' => 'required',
            'time' => 'required',
            'tax' => 'required',
            'tax_amount' => 'required',
            'total_amount' => 'required',
        ];
    }
}
