<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AppSetupRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'app_url' => 'required|url|max:255',
            'app_name' => 'required|max:255',
            'app_https' => 'nullable|boolean',
            'app_address' => 'nullable',
            'app_phone' => 'nullable|max:255',
            'app_user_registration' => 'required|boolean',
            'app_default_role' => 'required|exists:user_roles,id',
            'app_date_format' => 'required',
            'app_timezone' => 'required',
            'app_timezone' => 'required|max:255',
            'app_locale' => 'required|exists:languages,locale|max:255',
            'app_date_locale' => 'required|max:255',
            'app_date_format' => 'required|max:255',
            'app_icon' => 'sometimes',
            'app_background' => 'sometimes',
            'recaptcha_enabled' => 'required|boolean',
            'recaptcha_public' => 'required_if:recaptcha_enabled,true',
            'recaptcha_private' => 'required_if:recaptcha_enabled,true',
            'repair_invoice_terms' => 'sometimes',
            'bill_invoice_terms' => 'sometimes',
            'sale_invoice_terms' => 'sometimes',
            'custom_buy_invoice_terms' => 'sometimes',
        ];
    }
}
