<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AppConfigsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules = [
            'mail_mailer' => 'required',
            'mail_from_address' => 'required|email|max:255',
            'mail_from_name' => 'required|max:255',
            'currency_symbol' => 'required|max:10',
            'currency_symbol_on_left' => 'required|boolean',
            'currency_shorthand_notation' => 'required|boolean',
            'currency_space_between' => 'required|boolean',

            'tax_rate' => 'required|numeric',
            'is_tax_included' => 'boolean',
            'is_tax_fix' => 'boolean',
            'tax_id' => 'sometimes',
            'is_vat' => 'required',

            'pos_monies' => 'sometimes|max:255',
            'pos_scanner_focus_autofocus' => 'required',
            'pos_scanner_focus_duration' => 'required',
            'pos_scanner_processing_delay' => 'required',
            'pos_categories_default_numbers' => 'required',
            'pos_products_default_numbers' => 'required',

        ];

        if (request('mail_mailer') === 'smtp') {
            $rules['mail_host'] = 'required|max:255';
            $rules['mail_port'] = 'required|numeric';
            $rules['mail_username'] = 'required|max:255';
            $rules['mail_password'] = 'required';
            $rules['mail_encryption'] = 'required';
        }

        if (request('mail_mailer') === 'mailgun') {
            $rules['mailgun_domain'] = 'required';
            $rules['mailgun_secret'] = 'required';
            $rules['mailgun_endpoint'] = 'required';
        }

        return $rules;
    }
}
