<?php

namespace App\Http\Middleware;

use Auth;
use Closure;

class CheckIsAdmin
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if (!Auth::guard('sanctum')->check()) {
            return response()->json(['message' => __('Unauthorized')], 401);
        }

        $user = Auth::user();
        if ($user->userRole->admin_access) {
            return $next($request);
        }
        return response()->json(
            ['message' => 'Sorry you are not allowed to perform this action as a admin'],
            403
        );
    }
}
