<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\ApiController;
use App\Http\Resources\PosCategoriesResource;
use App\Http\Resources\PosCustomerResource;
use App\Http\Resources\PosProductAttributesResource;
use App\Http\Resources\PosProductsResource;
use App\Http\Resources\PosScanProductResource;
use App\Models\Category;
use App\Models\Customer;
use App\Models\Product;
use App\Models\ProductAttribute;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class PosController extends ApiController
{
    /**
     * Construct middleware and initiated backups list
     */
    public function __construct()
    {
        $this->middleware(['auth:sanctum']);
    }

    public function products(Request $request): JsonResponse
    {
        $sort = $this->sort($request);
        $products = Product::filter($request->all())->where('status', true)
            ->orderBy($sort['column'], $sort['order'])
            ->paginate((int) $request->get('perPage', $this->master()->pos_products_default_numbers ?? 10));
        return response()->json(
            [
                'products' => PosProductsResource::collection($products->items()),
                'pagination' => $this->pagination($products),
            ]
        );
    }

    public function customers(Request $request): JsonResponse
    {
        $customers = Customer::get();
        return response()->json(PosCustomerResource::collection($customers));
    }

    public function categories(): JsonResponse
    {

        $categories = Category::paginate($this->master()->pos_categories_default_numbers);
        return response()->json(
            [
                'categories' => PosCategoriesResource::collection($categories->items()),
                'pagination' => $this->pagination($categories),
            ]
        );
    }

    public function scanBarcode(Request $request): JsonResponse
    {
        $item = Product::where('upc', $request->barcode)->orWhere('identity', $request->barcode)->orWhere('serial_number', $request->barcode)->where('has_variants', false)->first();

        if ($item) {
            return response()->json(new PosScanProductResource($item));
        }

        $attribute = ProductAttribute::where('upc', $request->barcode)->orWhere('identity', $request->barcode)->orWhere('serial_number', $request->barcode)->first();

        if ($attribute) {
            return response()->json(new PosProductAttributesResource($attribute));
        }

        return response()->json(['message' => __('Item not found')], 422);
    }
}
