<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\ApiController;
use App\Http\Requests\ImageUploadRequest;
use Illuminate\Http\JsonResponse;

class ImageController extends ApiController
{
    /**
     * Construct middleware and initiated backups list
     */
    public function __construct()
    {
        $this->middleware(['auth:sanctum']);

    }

    public function upload(ImageUploadRequest $request): JsonResponse
    {
        $url = $request->file('image')->store($request->path, 'public');
        return response()->json([
            'url' => $url,
        ]);
    }
}
