<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\ApiController;
use App\Http\Resources\DashboardLastSoldProductsResource;
use App\Models\Category;
use App\Models\CustomBill;
use App\Models\CustomProduct;
use App\Models\Product;
use App\Models\Repair;
use App\Models\SaleOrder;
use App\Models\SaleOrderProduct;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class DashboardController extends ApiController
{
    /**
     * Construct middleware
     */
    public function __construct()
    {
        $this->middleware(['auth:sanctum', 'admin']);
    }

    public function index(Request $request): JsonResponse
    {
        $saleModel = SaleOrder::class;
        $repairModel = Repair::class;
        $duration = $request->is_duration;

        return response()->json([
            'dashboard' => [
                'sales_amount' => $this->calculateAmountFromModel($saleModel, 'payable_after_all', $duration),
                'last_sales_amount' => $this->calculateAmountFromModel($saleModel, 'payable_after_all', $duration, true),

                'total_tax_amount' => $this->calculateAmountFromModel($saleModel, 'tax_amount', $duration),
                'last_total_tax_amount' => $this->calculateAmountFromModel($saleModel, 'tax_amount', $duration, true),

                'sales_items' => $this->calculateAmountFromModel($saleModel, 'cart_total_items', $duration),
                'last_sales_items' => $this->calculateAmountFromModel($saleModel, 'cart_total_items', $duration, true),

                'sales_profit' => $this->calculateAmountFromModel($saleModel, 'profit_after_all', $duration),
                'last_sales_profit' => $this->calculateAmountFromModel($saleModel, 'profit_after_all', $duration, true),

                'sales_cost' => $this->calculateAmountFromModel($saleModel, 'cart_total_cost', $duration),
                'last_sales_cost' => $this->calculateAmountFromModel($saleModel, 'cart_total_cost', $duration, true),

                'repair_amount' => $this->calculateAmountFromModel($repairModel, 'total_amount', $duration),
                'last_repair_amount' => $this->calculateAmountFromModel($repairModel, 'total_amount', $duration, true),
            ],
            'chart' => $this->generateChartFromModel($saleModel, 'payable_after_all', $duration),
            'last_chart' => $this->generateChartFromModel($saleModel, 'payable_after_all', $duration, true),
            'sales_orders' => $this->lastSaleOrders(),
            'dash_data' => [
                'sales' => SaleOrder::count(),
                'repairs' => Repair::count(),
                'products' => Product::count(),
                'categories' => Category::count(),
                'custom_bills' => CustomBill::count(),
                'custom_products' => CustomProduct::count(),
            ],
        ]);
    }

    protected function lastSaleOrders()
    {
        $lastSales = SaleOrderProduct::latest()->limit(10)->get();
        return DashboardLastSoldProductsResource::collection($lastSales);
    }
}
